<?php

function solve($html)
{
    $data = [];
    $l = strlen($html);
    $index = 0;
    
    $is = false;
    $end = false;
    $tag = '';
    while ($index < $l) {
        while ($index < $l && preg_match('#\\s#', $c = $html[$index])) $index++;
        if ($index >= $l) break;
        
        $c = $html[$index++];
        if ('<' === $c) {
            if ($is) return false;
            
            $is = true;
            if ('/' === $html[$index]) {
                $index++;
                $end = true;
            } else {
                $end = false;
            }
            $tag = '';
            while ($index < $l && preg_match('#[a-z0-9\\-]#i', $c = $html[$index])) {
                $tag .= $c;
                $index++;
            }
            if (!strlen($tag)) return false;
            $tag = strtolower($tag);
            $tag = str_replace("/", "", $tag);
            if ($index < $l) {
                if (!preg_match('#[\\s/>]#', $html[$index])) return false;
                if ($end && preg_match('#^\\s*/>#sim', substr($html, $index))) return false;
            }
            if ($end) {
                if (array_pop($data) !== $tag)
                    return false;
            } else {
                $data[] = $tag;
            }
        } else if ('>' === $c) {
            if (!$is) return false;
            $is = false;
        }
    }
    return !$is && empty($data);
}

$input = trim(fgets(STDIN));
echo solve($input) ? "Yes" : "No";